package net.minecraft.world.gen;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

import java.util.Random;

public class MapGenCavesHell extends MapGenBase {
    protected void addRoom(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double posX, double posY, double posZ) {
        this.addTunnel(seed, chunkX, chunkZ, primer, posX, posY, posZ, 1.0F + this.rand.nextFloat() * 6.0F, 0.0F, 0.0F, -1, -1, 0.5D);
    }

    protected void addTunnel(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double posX, double posY, double posZ, float tunnelLength, float angleY, float angleX, int currentLength, int maxLength, double tunnelWidth) {
        double d0 = chunkX * 16 + 8;
        double d1 = chunkZ * 16 + 8;
        float f = 0.0F;
        float f1 = 0.0F;
        Random random = new Random(seed);

        if (maxLength <= 0) {
            int i = this.range * 16 - 16;
            maxLength = i - random.nextInt(i / 4);
        }

        boolean flag1 = false;

        if (currentLength == -1) {
            currentLength = maxLength / 2;
            flag1 = true;
        }

        int j = random.nextInt(maxLength / 2) + maxLength / 4;

        for (boolean flag = random.nextInt(6) == 0; currentLength < maxLength; ++currentLength) {
            double d2 = 1.5D + (double) (MathHelper.sin((float) currentLength * (float) Math.PI / (float) maxLength) * tunnelLength * 1.0F);
            double d3 = d2 * tunnelWidth;
            float f2 = MathHelper.cos(angleX);
            float f3 = MathHelper.sin(angleX);
            posX += MathHelper.cos(angleY) * f2;
            posY += f3;
            posZ += MathHelper.sin(angleY) * f2;

            if (flag) {
                angleX = angleX * 0.92F;
            } else {
                angleX = angleX * 0.7F;
            }

            angleX = angleX + f1 * 0.1F;
            angleY += f * 0.1F;
            f1 = f1 * 0.9F;
            f = f * 0.75F;
            f1 = f1 + (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0F;
            f = f + (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0F;

            if (!flag1 && currentLength == j && tunnelLength > 1.0F) {
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, posX, posY, posZ, random.nextFloat() * 0.5F + 0.5F, angleY - ((float) Math.PI / 2F), angleX / 3.0F, currentLength, maxLength, 1.0D);
                this.addTunnel(random.nextLong(), chunkX, chunkZ, primer, posX, posY, posZ, random.nextFloat() * 0.5F + 0.5F, angleY + ((float) Math.PI / 2F), angleX / 3.0F, currentLength, maxLength, 1.0D);
                return;
            }

            if (flag1 || random.nextInt(4) != 0) {
                double d4 = posX - d0;
                double d5 = posZ - d1;
                double d6 = maxLength - currentLength;
                double d7 = tunnelLength + 2.0F + 16.0F;

                if (d4 * d4 + d5 * d5 - d6 * d6 > d7 * d7) {
                    return;
                }

                if (posX >= d0 - 16.0D - d2 * 2.0D && posZ >= d1 - 16.0D - d2 * 2.0D && posX <= d0 + 16.0D + d2 * 2.0D && posZ <= d1 + 16.0D + d2 * 2.0D) {
                    int j2 = MathHelper.floor_double(posX - d2) - chunkX * 16 - 1;
                    int k = MathHelper.floor_double(posX + d2) - chunkX * 16 + 1;
                    int k2 = MathHelper.floor_double(posY - d3) - 1;
                    int l = MathHelper.floor_double(posY + d3) + 1;
                    int l2 = MathHelper.floor_double(posZ - d2) - chunkZ * 16 - 1;
                    int i1 = MathHelper.floor_double(posZ + d2) - chunkZ * 16 + 1;

                    if (j2 < 0) {
                        j2 = 0;
                    }

                    if (k > 16) {
                        k = 16;
                    }

                    if (k2 < 1) {
                        k2 = 1;
                    }

                    if (l > 120) {
                        l = 120;
                    }

                    if (l2 < 0) {
                        l2 = 0;
                    }

                    if (i1 > 16) {
                        i1 = 16;
                    }

                    boolean flag2 = false;

                    for (int j1 = j2; !flag2 && j1 < k; ++j1) {
                        for (int k1 = l2; !flag2 && k1 < i1; ++k1) {
                            for (int l1 = l + 1; !flag2 && l1 >= k2 - 1; --l1) {
                                if (l1 < 128) {
                                    IBlockState iblockstate = primer.getBlockState(j1, l1, k1);

                                    if (iblockstate.getBlock() == Blocks.flowing_lava || iblockstate.getBlock() == Blocks.lava) {
                                        flag2 = true;
                                    }

                                    if (l1 != k2 - 1 && j1 != j2 && j1 != k - 1 && k1 != l2 && k1 != i1 - 1) {
                                        l1 = k2;
                                    }
                                }
                            }
                        }
                    }

                    if (!flag2) {
                        for (int i3 = j2; i3 < k; ++i3) {
                            double d10 = ((double) (i3 + chunkX * 16) + 0.5D - posX) / d2;

                            for (int j3 = l2; j3 < i1; ++j3) {
                                double d8 = ((double) (j3 + chunkZ * 16) + 0.5D - posZ) / d2;

                                for (int i2 = l; i2 > k2; --i2) {
                                    double d9 = ((double) (i2 - 1) + 0.5D - posY) / d3;

                                    if (d9 > -0.7D && d10 * d10 + d9 * d9 + d8 * d8 < 1.0D) {
                                        IBlockState iblockstate1 = primer.getBlockState(i3, i2, j3);

                                        if (iblockstate1.getBlock() == Blocks.netherrack || iblockstate1.getBlock() == Blocks.dirt || iblockstate1.getBlock() == Blocks.grass) {
                                            primer.setBlockState(i3, i2, j3, Blocks.air.getDefaultState());
                                        }
                                    }
                                }
                            }
                        }

                        if (flag1) {
                            break;
                        }
                    }
                }
            }
        }
    }

    protected void recursiveGenerate(World worldIn, int chunkX, int chunkZ, int originalX, int originalZ, ChunkPrimer chunkPrimerIn) {
        int i = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(10) + 1) + 1);

        if (this.rand.nextInt(5) != 0) {
            i = 0;
        }

        for (int j = 0; j < i; ++j) {
            double d0 = chunkX * 16 + this.rand.nextInt(16);
            double d1 = this.rand.nextInt(128);
            double d2 = chunkZ * 16 + this.rand.nextInt(16);
            int k = 1;

            if (this.rand.nextInt(4) == 0) {
                this.addRoom(this.rand.nextLong(), originalX, originalZ, chunkPrimerIn, d0, d1, d2);
                k += this.rand.nextInt(4);
            }

            for (int l = 0; l < k; ++l) {
                float f = this.rand.nextFloat() * (float) Math.PI * 2.0F;
                float f1 = (this.rand.nextFloat() - 0.5F) * 2.0F / 8.0F;
                float f2 = this.rand.nextFloat() * 2.0F + this.rand.nextFloat();
                this.addTunnel(this.rand.nextLong(), originalX, originalZ, chunkPrimerIn, d0, d1, d2, f2 * 2.0F, f, f1, 0, 0, 0.5D);
            }
        }
    }
}
