package net.minecraft.util;

import java.lang.reflect.Array;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ThreadSafeBoundList<T> {
    private final T[] items;
    private final Class<? extends T> itemClass;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private int itemCount;
    private int nextIndex;

    public ThreadSafeBoundList(Class<? extends T> clazz, int nums) {
        this.itemClass = clazz;
        this.items = (T[]) Array.newInstance(clazz, nums);
    }

    public T addItem(T item) {
        this.lock.writeLock().lock();
        this.items[this.nextIndex] = item;
        this.nextIndex = (this.nextIndex + 1) % this.capacity();

        if (this.itemCount < this.capacity()) {
            ++this.itemCount;
        }

        this.lock.writeLock().unlock();
        return item;
    }

    public int capacity() {
        this.lock.readLock().lock();
        int i = this.items.length;
        this.lock.readLock().unlock();
        return i;
    }

    public T[] getItems() {
        T[] at = (T[]) Array.newInstance(this.itemClass, this.itemCount);
        this.lock.readLock().lock();

        for (int i = 0; i < this.itemCount; ++i) {
            int j = (this.nextIndex - this.itemCount + i) % this.capacity();

            if (j < 0) {
                j += this.capacity();
            }

            at[i] = this.items[j];
        }

        this.lock.readLock().unlock();
        return at;
    }
}