package net.minecraft.util;

import net.bloom.bloomclient.BloomClient;
import net.bloom.bloomclient.event.MoveInputEvent;
import net.minecraft.client.option.options.devices.KeyBinding;

public class MovementInputFromOptions extends MovementInput {

    public MovementInputFromOptions() {}

    public void updatePlayerMoveState() {
        final float lastForward = this.moveForward;
        final float lastStrafe = this.moveStrafe;

        this.moveStrafe = 0.0F;
        this.moveForward = 0.0F;

        if (KeyBinding.keyBindForward.isKeyDown()) {
            ++this.moveForward;
        }

        if (KeyBinding.keyBindBack.isKeyDown()) {
            --this.moveForward;
        }

        if (KeyBinding.keyBindLeft.isKeyDown()) {
            ++this.moveStrafe;
        }

        if (KeyBinding.keyBindRight.isKeyDown()) {
            --this.moveStrafe;
        }

        this.jump = KeyBinding.keyBindJump.isKeyDown();
        this.sneak = KeyBinding.keyBindSneak.isKeyDown();
        final MoveInputEvent event = new MoveInputEvent(this.moveForward, this.moveStrafe, lastForward, lastStrafe, this.jump, this.sneak, 0.3D);
        BloomClient.eventManager.call(event);

        this.moveForward = event.getForward();
        this.moveStrafe = event.getStrafe();
        this.jump = event.getJump();
        this.sneak = event.getSneak();

        final double sneakMultiplier = event.getSneakMultiplier();

        if (this.sneak) {
            this.moveStrafe = (float) (this.moveStrafe * sneakMultiplier);
            this.moveForward = (float) (this.moveForward * sneakMultiplier);
        }
    }
}
