package net.minecraft.util;

import net.minecraft.entity.EntityLivingBase;

public class CombatEntry {
    private final DamageSource damageSrc;
    private final float damage;
    private final String fallSuffix;
    private final float fallDistance;

    public CombatEntry(DamageSource damageSrcIn, int timeIn, float healthAmount, float damageAmount, String fallSuffixIn, float fallDistanceIn) {
        this.damageSrc = damageSrcIn;
        this.damage = damageAmount;
        this.fallSuffix = fallSuffixIn;
        this.fallDistance = fallDistanceIn;
    }

    public DamageSource getDamageSrc() {
        return this.damageSrc;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isLivingDamageSrc() {
        return this.damageSrc.getEntity() instanceof EntityLivingBase;
    }

    public String getFallSuffix() {
        return this.fallSuffix;
    }

    public IChatComponent getDamageSrcDisplayName() {
        return this.getDamageSrc().getEntity() == null ? null : this.getDamageSrc().getEntity().getDisplayName();
    }

    public float getDamageAmount() {
        return this.damageSrc == DamageSource.outOfWorld ? Float.MAX_VALUE : this.fallDistance;
    }
}
