package net.minecraft.scoreboard;

import com.google.common.collect.Maps;

import java.util.Collection;
import java.util.Map;

public abstract class Team {
    public boolean isSameTeam(Team other) {
        return this == other;
    }

    public abstract String getRegisteredName();

    public abstract String formatString(String input);

    public abstract boolean getSeeFriendlyInvisiblesEnabled();

    public abstract boolean getAllowFriendlyFire();

    public abstract Team.EnumVisible getNameTagVisibility();

    public abstract Collection<String> getMembershipCollection();

    public abstract Team.EnumVisible getDeathMessageVisibility();

    public enum EnumVisible {
        ALWAYS("always", 0),
        NEVER("never", 1),
        HIDE_FOR_OTHER_TEAMS("hideForOtherTeams", 2),
        HIDE_FOR_OWN_TEAM("hideForOwnTeam", 3);

        private static final Map<String, Team.EnumVisible> teamVisibleMap = Maps.newHashMap();

        static {
            for (Team.EnumVisible team$enumvisible : values()) {
                teamVisibleMap.put(team$enumvisible.internalName, team$enumvisible);
            }
        }

        public final String internalName;
        public final int id;

        EnumVisible(String nameIn, int idIn) {
            this.internalName = nameIn;
            this.id = idIn;
        }

        public static String[] getNames() {
            return teamVisibleMap.keySet().toArray(new String[0]);
        }

        public static Team.EnumVisible getByName(String nameIn) {
            return teamVisibleMap.get(nameIn);
        }
    }
}
