package net.minecraft.scoreboard;

import com.google.common.collect.Sets;
import net.minecraft.util.EnumChatFormatting;

import java.util.Collection;
import java.util.Set;

public class ScorePlayerTeam extends Team {
    private final Scoreboard theScoreboard;
    private final String registeredName;
    private final Set<String> membershipSet = Sets.newHashSet();
    private String teamNameSPT;
    private String namePrefixSPT = "";
    private String colorSuffix = "";
    private boolean allowFriendlyFire = true;
    private boolean canSeeFriendlyInvisibles = true;
    private Team.EnumVisible nameTagVisibility = Team.EnumVisible.ALWAYS;
    private Team.EnumVisible deathMessageVisibility = Team.EnumVisible.ALWAYS;
    private EnumChatFormatting chatFormat = EnumChatFormatting.RESET;

    public ScorePlayerTeam(Scoreboard theScoreboardIn, String name) {
        this.theScoreboard = theScoreboardIn;
        this.registeredName = name;
        this.teamNameSPT = name;
    }

    public static String formatPlayerName(Team teamIn, String string) {
        return teamIn == null ? string : teamIn.formatString(string);
    }

    public String getRegisteredName() {
        return this.registeredName;
    }

    public String getTeamName() {
        return this.teamNameSPT;
    }

    public void setTeamName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        } else {
            this.teamNameSPT = name;
            this.theScoreboard.sendTeamUpdate(this);
        }
    }

    public Collection<String> getMembershipCollection() {
        return this.membershipSet;
    }

    public String getColorPrefix() {
        return this.namePrefixSPT;
    }

    public void setNamePrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        } else {
            this.namePrefixSPT = prefix;
            this.theScoreboard.sendTeamUpdate(this);
        }
    }

    public String getColorSuffix() {
        return this.colorSuffix;
    }

    public void setNameSuffix(String suffix) {
        this.colorSuffix = suffix;
        this.theScoreboard.sendTeamUpdate(this);
    }

    public String formatString(String input) {
        return this.getColorPrefix() + input + this.getColorSuffix();
    }

    public boolean getAllowFriendlyFire() {
        return this.allowFriendlyFire;
    }

    public void setAllowFriendlyFire(boolean friendlyFire) {
        this.allowFriendlyFire = friendlyFire;
        this.theScoreboard.sendTeamUpdate(this);
    }

    public boolean getSeeFriendlyInvisiblesEnabled() {
        return this.canSeeFriendlyInvisibles;
    }

    public void setSeeFriendlyInvisiblesEnabled(boolean friendlyInvisibles) {
        this.canSeeFriendlyInvisibles = friendlyInvisibles;
        this.theScoreboard.sendTeamUpdate(this);
    }

    public Team.EnumVisible getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    public void setNameTagVisibility(Team.EnumVisible visibility) {
        this.nameTagVisibility = visibility;
        this.theScoreboard.sendTeamUpdate(this);
    }

    public Team.EnumVisible getDeathMessageVisibility() {
        return this.deathMessageVisibility;
    }

    public void setDeathMessageVisibility(Team.EnumVisible visibility) {
        this.deathMessageVisibility = visibility;
        this.theScoreboard.sendTeamUpdate(this);
    }

    public int getFriendlyFlags() {
        int i = 0;

        if (this.getAllowFriendlyFire()) {
            i |= 1;
        }

        if (this.getSeeFriendlyInvisiblesEnabled()) {
            i |= 2;
        }

        return i;
    }

    public void setFriendlyFlags(int flags) {
        this.setAllowFriendlyFire((flags & 1) > 0);
        this.setSeeFriendlyInvisiblesEnabled((flags & 2) > 0);
    }

    public EnumChatFormatting getChatFormat() {
        return this.chatFormat;
    }

    public void setChatFormat(EnumChatFormatting format) {
        this.chatFormat = format;
    }
}
