package net.minecraft.network.play.server;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.CombatTracker;

public class S42PacketCombatEvent extends Packet<INetHandlerPlayClient> {
    public S42PacketCombatEvent.Event eventType;
    public int playerId;
    public int entityId;
    public int duration;
    public String deathMessage;

    public S42PacketCombatEvent() {
    }

    @SuppressWarnings("incomplete-switch")
    public S42PacketCombatEvent(CombatTracker combatTrackerIn, S42PacketCombatEvent.Event combatEventType) {
        this.eventType = combatEventType;
        EntityLivingBase entitylivingbase = combatTrackerIn.getBestAttacker();

        switch (combatEventType) {
            case END_COMBAT:
                this.duration = combatTrackerIn.getCombatDuration();
                this.entityId = entitylivingbase == null ? -1 : entitylivingbase.getEntityId();
                break;

            case ENTITY_DIED:
                this.playerId = combatTrackerIn.getFighter().getEntityId();
                this.entityId = entitylivingbase == null ? -1 : entitylivingbase.getEntityId();
                this.deathMessage = combatTrackerIn.getDeathMessage().getUnformattedText();
        }
    }

    public void readPacketData(PacketBuffer buf) {
        this.eventType = buf.readEnumValue(Event.class);

        if (this.eventType == S42PacketCombatEvent.Event.END_COMBAT) {
            this.duration = buf.readVarIntFromBuffer();
            this.entityId = buf.readInt();
        } else if (this.eventType == S42PacketCombatEvent.Event.ENTITY_DIED) {
            this.playerId = buf.readVarIntFromBuffer();
            this.entityId = buf.readInt();
            this.deathMessage = buf.readStringFromBuffer(32767);
        }
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeEnumValue(this.eventType);

        if (this.eventType == S42PacketCombatEvent.Event.END_COMBAT) {
            buf.writeVarIntToBuffer(this.duration);
            buf.writeInt(this.entityId);
        } else if (this.eventType == S42PacketCombatEvent.Event.ENTITY_DIED) {
            buf.writeVarIntToBuffer(this.playerId);
            buf.writeInt(this.entityId);
            buf.writeString(this.deathMessage);
        }
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleCombatEvent(this);
    }

    public enum Event {
        ENTER_COMBAT,
        END_COMBAT,
        ENTITY_DIED
    }
}
