package net.minecraft.network.play.server;

import com.google.common.collect.Maps;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;

import java.util.Map;
import java.util.Map.Entry;

public class S37PacketStatistics extends Packet<INetHandlerPlayClient> {
    private Map<StatBase, Integer> statisticMap;

    public S37PacketStatistics() {
    }

    public S37PacketStatistics(Map<StatBase, Integer> statisticMap) {
        this.statisticMap = statisticMap;
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleStatistics(this);
    }

    public void readPacketData(PacketBuffer buf) {
        int i = buf.readVarIntFromBuffer();
        this.statisticMap = Maps.newHashMap();

        for (int j = 0; j < i; ++j) {
            StatBase statbase = StatList.getOneShotStat(buf.readStringFromBuffer(32767));
            int k = buf.readVarIntFromBuffer();

            if (statbase != null) {
                this.statisticMap.put(statbase, k);
            }
        }
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeVarIntToBuffer(this.statisticMap.size());

        for (Entry<StatBase, Integer> entry : this.statisticMap.entrySet()) {
            buf.writeString(entry.getKey().statId);
            buf.writeVarIntToBuffer(entry.getValue());
        }
    }

    public Map<StatBase, Integer> getStatisticMap() {
        return this.statisticMap;
    }
}
