package net.minecraft.network.play.server;

import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class S33PacketUpdateSign extends Packet<INetHandlerPlayClient> {
    private BlockPos blockPos;
    private IChatComponent[] lines;

    public S33PacketUpdateSign() {
    }

    public S33PacketUpdateSign(World worldIn, BlockPos blockPosIn, IChatComponent[] linesIn) {
        this.blockPos = blockPosIn;
        this.lines = new IChatComponent[]{linesIn[0], linesIn[1], linesIn[2], linesIn[3]};
    }

    public void readPacketData(PacketBuffer buf) {
        this.blockPos = buf.readBlockPos();
        this.lines = new IChatComponent[4];

        for (int i = 0; i < 4; ++i) {
            this.lines[i] = buf.readChatComponent();
        }
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeBlockPos(this.blockPos);

        for (int i = 0; i < 4; ++i) {
            buf.writeChatComponent(this.lines[i]);
        }
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleUpdateSign(this);
    }

    public BlockPos getPos() {
        return this.blockPos;
    }

    public IChatComponent[] getLines() {
        return this.lines;
    }
}
