package net.minecraft.network.play.server;

import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;

public class S2BPacketChangeGameState extends Packet<INetHandlerPlayClient> {
    public static final String[] MESSAGE_NAMES = new String[]{"tile.bed.notValid"};
    private int state;
    private float value;

    public S2BPacketChangeGameState() {
    }

    public S2BPacketChangeGameState(int stateIn, float value) {
        this.state = stateIn;
        this.value = value;
    }

    public void readPacketData(PacketBuffer buf) {
        this.state = buf.readUnsignedByte();
        this.value = buf.readFloat();
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeByte(this.state);
        buf.writeFloat(this.value);
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleChangeGameState(this);
    }

    public int getGameState() {
        return this.state;
    }

    public float getValue() {
        return this.value;
    }
}
