package net.minecraft.network.play.server;

import net.minecraft.entity.DataWatcher;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;

import java.io.IOException;
import java.util.List;

public class S1CPacketEntityMetadata extends Packet<INetHandlerPlayClient> {
    private int entityId;
    private List<DataWatcher.WatchableObject> dataManagerEntries;

    public S1CPacketEntityMetadata() {
    }

    public S1CPacketEntityMetadata(int entityIdIn, DataWatcher watcher, boolean getAll) {
        this.entityId = entityIdIn;

        if (getAll) {
            this.dataManagerEntries = watcher.getAllWatched();
        } else {
            this.dataManagerEntries = watcher.getChanged();
        }
    }

    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityId = buf.readVarIntFromBuffer();
        this.dataManagerEntries = DataWatcher.readWatchedListFromPacketBuffer(buf);
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeVarIntToBuffer(this.entityId);
        DataWatcher.writeWatchedListToPacketBuffer(this.dataManagerEntries, buf);
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleEntityMetadata(this);
    }

    public List<DataWatcher.WatchableObject> getDataManagerEntries() {
        return this.dataManagerEntries;
    }

    public int getEntityId() {
        return this.entityId;
    }
}
