package net.minecraft.network.play.server;

import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;

import java.util.EnumSet;
import java.util.Set;

public class S08PacketPlayerPosLook extends Packet<INetHandlerPlayClient> {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private Set<S08PacketPlayerPosLook.EnumFlags> flags;

    public S08PacketPlayerPosLook() {
    }

    public S08PacketPlayerPosLook(double xIn, double yIn, double zIn, float yawIn, float pitchIn, Set<S08PacketPlayerPosLook.EnumFlags> flags) {
        this.x = xIn;
        this.y = yIn;
        this.z = zIn;
        this.yaw = yawIn;
        this.pitch = pitchIn;
        this.flags = flags;
    }

    public void readPacketData(PacketBuffer buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.flags = S08PacketPlayerPosLook.EnumFlags.fromValue(buf.readUnsignedByte());
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeByte(S08PacketPlayerPosLook.EnumFlags.toValue(this.flags));
    }

    public void processPacket(INetHandlerPlayClient handler) {
        handler.handlePlayerPosLook(this);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Set<S08PacketPlayerPosLook.EnumFlags> getFlags() {
        return this.flags;
    }

    public enum EnumFlags {
        X(0),
        Y(1),
        Z(2),
        Y_ROT(3),
        X_ROT(4);

        private final int flag;

        EnumFlags(int flag) {
            this.flag = flag;
        }

        public static Set<S08PacketPlayerPosLook.EnumFlags> fromValue(int value) {
            Set<S08PacketPlayerPosLook.EnumFlags> set = EnumSet.noneOf(S08PacketPlayerPosLook.EnumFlags.class);

            for (S08PacketPlayerPosLook.EnumFlags s08packetplayerposlook$enumflags : values()) {
                if (s08packetplayerposlook$enumflags.isFlagSet(value)) {
                    set.add(s08packetplayerposlook$enumflags);
                }
            }

            return set;
        }

        public static int toValue(Set<S08PacketPlayerPosLook.EnumFlags> flags) {
            int i = 0;

            for (S08PacketPlayerPosLook.EnumFlags s08packetplayerposlook$enumflags : flags) {
                i |= s08packetplayerposlook$enumflags.getBitmask();
            }

            return i;
        }

        private int getBitmask() {
            return 1 << this.flag;
        }

        private boolean isFlagSet(int value) {
            return (value & this.getBitmask()) == this.getBitmask();
        }
    }
}
