package net.minecraft.network.play.client;

import de.florianmichael.viamcp.fixes.ChatLength;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayServer;

public class C01PacketChatMessage extends Packet<INetHandlerPlayServer> {
    private String message;

    public C01PacketChatMessage() {
    }

    public C01PacketChatMessage(String messageIn) {
        int chatLength = ChatLength.getChatLength();

        if (messageIn.length() > chatLength) {
            messageIn = messageIn.substring(0, chatLength);
        }

        this.message = messageIn;
    }

    public void readPacketData(PacketBuffer buf) {
        this.message = buf.readStringFromBuffer(ChatLength.getChatLength());
    }

    public void writePacketData(PacketBuffer buf) {
        buf.writeString(this.message);
    }

    public void processPacket(INetHandlerPlayServer handler) {
        handler.processChatMessage(this);
    }

    public String getMessage() {
        return this.message;
    }
}
