package net.minecraft.item;

import com.google.common.collect.Sets;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;

import java.util.Set;

public class ItemAxe extends ItemTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet(Blocks.planks, Blocks.bookshelf, Blocks.log, Blocks.log2, Blocks.chest, Blocks.pumpkin, Blocks.lit_pumpkin, Blocks.melon_block, Blocks.ladder);

    protected ItemAxe(Item.ToolMaterial material) {
        super(3.0F, material, EFFECTIVE_ON);
    }

    public float getStrVsBlock(ItemStack stack, Block state) {
        return state.getMaterial() != Material.wood && state.getMaterial() != Material.plants && state.getMaterial() != Material.vine ? super.getStrVsBlock(stack, state) : this.efficiencyOnProperMaterial;
    }

    /**
     * @link https://github.com/BloomArchives/Optifine-1.9.4/blob/main/net/minecraft/item/ItemAxe.java#L14
     */

    @Override
    public double getModernGenericAttackSpeed() {
        return switch (toolMaterial) {
            case WOOD, STONE -> 0.8;
            case IRON -> 0.9;
            default -> 1.0;
        };
    }
}
