package net.minecraft.entity.ai;

import com.google.common.base.Predicate;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;

public class EntityAIFindEntityNearest extends EntityAIBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityLiving mob;
    private final Predicate<EntityLivingBase> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private final Class<? extends EntityLivingBase> classToCheck;
    private EntityLivingBase target;

    public EntityAIFindEntityNearest(EntityLiving mobIn, Class<? extends EntityLivingBase> clazz) {
        this.mob = mobIn;
        this.classToCheck = clazz;

        if (mobIn instanceof EntityCreature) {
            LOGGER.warn("Use NearestAttackableTargetGoal.class for PathfinerMob mobs!");
        }

        this.predicate = p_apply_1_ -> {
            double d0 = EntityAIFindEntityNearest.this.getFollowRange();

            if (p_apply_1_.isSneaking()) {
                d0 *= 0.800000011920929D;
            }

            return !p_apply_1_.isInvisible() && (!((double) p_apply_1_.getDistanceToEntity(EntityAIFindEntityNearest.this.mob) > d0) && EntityAITarget.isSuitableTarget(EntityAIFindEntityNearest.this.mob, p_apply_1_, false, true));
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter(mobIn);
    }

    public boolean shouldExecute() {
        double d0 = this.getFollowRange();
        List<EntityLivingBase> list = this.mob.worldObj.getEntitiesWithinAABB(this.classToCheck, this.mob.getEntityBoundingBox().expand(d0, 4.0D, d0), this.predicate);
        list.sort(this.sorter);

        if (list.isEmpty()) {
            return false;
        } else {
            this.target = list.get(0);
            return true;
        }
    }

    public boolean continueExecuting() {
        EntityLivingBase entitylivingbase = this.mob.getAttackTarget();

        if (entitylivingbase == null) {
            return false;
        } else if (!entitylivingbase.isEntityAlive()) {
            return false;
        } else {
            double d0 = this.getFollowRange();
            return !(this.mob.getDistanceSqToEntity(entitylivingbase) > d0 * d0) && (!(entitylivingbase instanceof EntityPlayerMP) || !((EntityPlayerMP) entitylivingbase).theItemInWorldManager.isCreative());
        }
    }

    public void startExecuting() {
        this.mob.setAttackTarget(this.target);
        super.startExecuting();
    }

    public void resetTask() {
        this.mob.setAttackTarget(null);
        super.startExecuting();
    }

    protected double getFollowRange() {
        IAttributeInstance iattributeinstance = this.mob.getEntityAttribute(SharedMonsterAttributes.followRange);
        return iattributeinstance == null ? 16.0D : iattributeinstance.getAttributeValue();
    }
}
