package net.minecraft.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryMerchant;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class NpcMerchant implements IMerchant {
    private final EntityPlayer customer;
    private final IChatComponent name;
    private MerchantRecipeList recipeList;

    public NpcMerchant(EntityPlayer customerIn, IChatComponent nameIn) {
        this.customer = customerIn;
        this.name = nameIn;
        InventoryMerchant theMerchantInventory = new InventoryMerchant(customerIn, this);
    }

    public EntityPlayer getCustomer() {
        return this.customer;
    }

    public void setCustomer(EntityPlayer player) {
    }

    public MerchantRecipeList getRecipes(EntityPlayer player) {
        return this.recipeList;
    }

    public void setRecipes(MerchantRecipeList recipeList) {
        this.recipeList = recipeList;
    }

    public void useRecipe(MerchantRecipe recipe) {
        recipe.incrementToolUses();
    }

    public void verifySellingItem(ItemStack stack) {
    }

    public IChatComponent getDisplayName() {
        return this.name != null ? this.name : new ChatComponentTranslation("entity.Villager.name");
    }
}
