package net.minecraft.enchantment;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

import java.util.Random;

public class EnchantmentThorns extends Enchantment {
    public EnchantmentThorns(int enchID, ResourceLocation enchName, int enchWeight) {
        super(enchID, enchName, enchWeight, EnumEnchantmentType.ARMOR_TORSO);
        this.setName("thorns");
    }

    public static boolean shouldHit(int level, Random rnd) {
        return level > 0 && rnd.nextFloat() < 0.15F * (float) level;
    }

    public static int getDamage(int level, Random rnd) {
        return level > 10 ? level - 10 : 1 + rnd.nextInt(4);
    }

    public int getMinEnchantability(int enchantmentLevel) {
        return 10 + 20 * (enchantmentLevel - 1);
    }

    public int getMaxEnchantability(int enchantmentLevel) {
        return super.getMinEnchantability(enchantmentLevel) + 50;
    }

    public int getMaxLevel() {
        return 3;
    }

    public boolean canApply(ItemStack stack) {
        return stack.getItem() instanceof ItemArmor || super.canApply(stack);
    }

    public void onUserHurt(EntityLivingBase user, Entity attacker, int level) {
        Random random = user.getRNG();
        ItemStack itemstack = EnchantmentHelper.getEnchantedItem(Enchantments.thorns, user);

        if (shouldHit(level, random)) {
            if (attacker != null) {
                attacker.attackEntityFrom(DamageSource.causeThornsDamage(user), (float) getDamage(level, random));
                attacker.playSound("damage.thorns", 0.5F, 1.0F);
            }

            if (itemstack != null) {
                itemstack.damageItem(3, user);
            }
        } else if (itemstack != null) {
            itemstack.damageItem(1, user);
        }
    }
}
