package net.minecraft.enchantment;

import club.patcher.RomanNumerals;
import net.minecraft.client.option.options.general.WorldOption;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public abstract class Enchantment {

    public final int effectId;
    private final int weight;
    public EnumEnchantmentType type;
    protected String name;

    public final ResourceLocation enchantResource;

    protected Enchantment(int enchID, ResourceLocation enchName, int enchWeight, EnumEnchantmentType enchType) {
        this.effectId = enchID;
        this.weight = enchWeight;
        this.type = enchType;
        this.enchantResource = enchName;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return 1;
    }

    public int getMinEnchantability(int enchantmentLevel) {
        return 1 + enchantmentLevel * 10;
    }

    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 5;
    }

    public int calcModifierDamage(int level, DamageSource source) {
        return 0;
    }

    public float calcDamageByCreature(int level, EnumCreatureAttribute creatureType) {
        return 0.0F;
    }

    public boolean canApplyTogether(Enchantment ench) {
        return this != ench;
    }

    public String getName() {
        return "enchantment." + this.name;
    }

    public Enchantment setName(String enchName) {
        this.name = enchName;
        return this;
    }

    public String getTranslatedName(int level) {
        String s = StatCollector.translateToLocal(this.getName()) + " ";

        if (WorldOption.isNumericalEnchanment()) {
            return s + level;
        } else if (WorldOption.isBetterRomanNumerals()) {
            return s + RomanNumerals.toRoman(level);
        }

        return s + StatCollector.translateToLocal("enchantment.level." + level);
    }

    public boolean canApply(ItemStack stack) {
        return this.type.canEnchantItem(stack.getItem());
    }

    public void onEntityDamaged(EntityLivingBase user, Entity target, int level) {
    }

    public void onUserHurt(EntityLivingBase user, Entity attacker, int level) {
    }
}
