package net.minecraft.client.resources.data;

import it.unimi.dsi.fastutil.ints.IntArrayList;

import java.util.Collections;
import java.util.List;

public class TextureMetadataSection implements IMetadataSection {
    private final boolean textureBlur;
    private final boolean textureClamp;
    private final IntArrayList listMipmaps;

    public TextureMetadataSection(boolean blur, boolean clamp, IntArrayList mipmapList) {
        this.textureBlur = blur;
        this.textureClamp = clamp;
        this.listMipmaps = mipmapList;
    }

    public boolean getTextureBlur() {
        return this.textureBlur;
    }

    public boolean getTextureClamp() {
        return this.textureClamp;
    }

    public IntArrayList getListMipmaps() {
        return listMipmaps.clone();
    }
}
