package net.minecraft.client.renderer.block.model;

import com.google.gson.*;
import net.minecraft.client.renderer.GlStateManager;

import java.lang.reflect.Type;

public class ItemCameraTransforms {
    public static final ItemCameraTransforms DEFAULT = new ItemCameraTransforms();
    public static final float offsetTranslateX = 0.0F;
    public static final float offsetTranslateY = 0.0F;
    public static final float offsetTranslateZ = 0.0F;
    public static final float offsetRotationX = 0.0F;
    public static final float offsetRotationY = 0.0F;
    public static final float offsetRotationZ = 0.0F;
    public static final float offsetScaleX = 0.0F;
    public static final float offsetScaleY = 0.0F;
    public static final float offsetScaleZ = 0.0F;
    public final ItemTransformVec3f thirdPerson;
    public final ItemTransformVec3f firstPerson;
    public final ItemTransformVec3f head;
    public final ItemTransformVec3f gui;
    public final ItemTransformVec3f ground;
    public final ItemTransformVec3f fixed;

    private ItemCameraTransforms() {
        this(ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT, ItemTransformVec3f.DEFAULT);
    }

    public ItemCameraTransforms(ItemCameraTransforms transforms) {
        this.thirdPerson = transforms.thirdPerson;
        this.firstPerson = transforms.firstPerson;
        this.head = transforms.head;
        this.gui = transforms.gui;
        this.ground = transforms.ground;
        this.fixed = transforms.fixed;
    }

    public ItemCameraTransforms(ItemTransformVec3f thirdPersonIn, ItemTransformVec3f firstPersonIn, ItemTransformVec3f headIn, ItemTransformVec3f guiIn, ItemTransformVec3f groundIn, ItemTransformVec3f fixedIn) {
        this.thirdPerson = thirdPersonIn;
        this.firstPerson = firstPersonIn;
        this.head = headIn;
        this.gui = guiIn;
        this.ground = groundIn;
        this.fixed = fixedIn;
    }

    public void applyTransform(ItemCameraTransforms.TransformType type) {
        ItemTransformVec3f itemtransformvec3f = this.getTransform(type);

        if (itemtransformvec3f != ItemTransformVec3f.DEFAULT) {
            GlStateManager.translate(itemtransformvec3f.translation.x + offsetTranslateX, itemtransformvec3f.translation.y + offsetTranslateY, itemtransformvec3f.translation.z + offsetTranslateZ);
            GlStateManager.rotate(itemtransformvec3f.rotation.y + offsetRotationY, 0.0F, 1.0F, 0.0F);
            GlStateManager.rotate(itemtransformvec3f.rotation.x + offsetRotationX, 1.0F, 0.0F, 0.0F);
            GlStateManager.rotate(itemtransformvec3f.rotation.z + offsetRotationZ, 0.0F, 0.0F, 1.0F);
            GlStateManager.scale(itemtransformvec3f.scale.x + offsetScaleX, itemtransformvec3f.scale.y + offsetScaleY, itemtransformvec3f.scale.z + offsetScaleZ);
        }
    }

    public ItemTransformVec3f getTransform(ItemCameraTransforms.TransformType type) {
        return switch (type) {
            case THIRD_PERSON -> this.thirdPerson;
            case FIRST_PERSON -> this.firstPerson;
            case HEAD -> this.head;
            case GUI -> this.gui;
            case GROUND -> this.ground;
            case FIXED -> this.fixed;
            default -> ItemTransformVec3f.DEFAULT;
        };
    }

    public boolean hasCustomTransform(ItemCameraTransforms.TransformType type) {
        return !this.getTransform(type).equals(ItemTransformVec3f.DEFAULT);
    }

    public enum TransformType {
        NONE,
        THIRD_PERSON,
        FIRST_PERSON,
        HEAD,
        GUI,
        GROUND,
        FIXED
    }

    static class Deserializer implements JsonDeserializer<ItemCameraTransforms> {
        public ItemCameraTransforms deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
            ItemTransformVec3f itemtransformvec3f = this.getTransform(p_deserialize_3_, jsonobject, "thirdperson");
            ItemTransformVec3f itemtransformvec3f1 = this.getTransform(p_deserialize_3_, jsonobject, "firstperson");
            ItemTransformVec3f itemtransformvec3f2 = this.getTransform(p_deserialize_3_, jsonobject, "head");
            ItemTransformVec3f itemtransformvec3f3 = this.getTransform(p_deserialize_3_, jsonobject, "gui");
            ItemTransformVec3f itemtransformvec3f4 = this.getTransform(p_deserialize_3_, jsonobject, "ground");
            ItemTransformVec3f itemtransformvec3f5 = this.getTransform(p_deserialize_3_, jsonobject, "fixed");
            return new ItemCameraTransforms(itemtransformvec3f, itemtransformvec3f1, itemtransformvec3f2, itemtransformvec3f3, itemtransformvec3f4, itemtransformvec3f5);
        }

        private ItemTransformVec3f getTransform(JsonDeserializationContext context, JsonObject jsonObject, String key) {
            return jsonObject.has(key) ? (ItemTransformVec3f) context.deserialize(jsonObject.get(key), ItemTransformVec3f.class) : ItemTransformVec3f.DEFAULT;
        }
    }
}
