package net.minecraft.client.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.src.Config;
import net.minecraft.world.World;
import net.optifine.shaders.Program;
import net.optifine.shaders.Shaders;

public class EntityPickupFX extends EntityFX {
    private final Entity item;
    private final Entity target;
    private final int maxAge;
    private final float yOffset;
    private final RenderManager renderManager = Minecraft.getMinecraft().getRenderManager();
    private int age;

    public EntityPickupFX(World worldIn, Entity entityIn, Entity targetEntityIn, float yOffsetIn) {
        super(worldIn, entityIn.posX, entityIn.posY, entityIn.posZ, entityIn.motionX, entityIn.motionY, entityIn.motionZ);
        this.item = entityIn;
        this.target = targetEntityIn;
        this.maxAge = 3;
        this.yOffset = yOffsetIn;
    }

    public void renderParticle(WorldRenderer worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Program program = null;

        if (Config.isShaders()) {
            program = Shaders.activeProgram;
            Shaders.nextEntity(this.item);
        }

        float f = ((float) this.age + partialTicks) / (float) this.maxAge;
        f = f * f;
        double d0 = this.item.posX;
        double d1 = this.item.posY;
        double d2 = this.item.posZ;
        double d3 = this.target.lastTickPosX + (this.target.posX - this.target.lastTickPosX) * (double) partialTicks;
        double d4 = this.target.lastTickPosY + (this.target.posY - this.target.lastTickPosY) * (double) partialTicks + (double) this.yOffset;
        double d5 = this.target.lastTickPosZ + (this.target.posZ - this.target.lastTickPosZ) * (double) partialTicks;
        double d6 = d0 + (d3 - d0) * (double) f;
        double d7 = d1 + (d4 - d1) * (double) f;
        double d8 = d2 + (d5 - d2) * (double) f;
        int i = this.getBrightnessForRender(partialTicks);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, (float) j, (float) k);
        GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
        d6 = d6 - interpPosX;
        d7 = d7 - interpPosY;
        d8 = d8 - interpPosZ;
        this.renderManager.renderEntityWithPosYaw(this.item, (float) d6, (float) d7, (float) d8, this.item.rotationYaw, partialTicks);

        if (Config.isShaders()) {
            Shaders.setEntityId(null);
            Shaders.useProgram(program);
        }
    }

    public void onUpdate() {
        ++this.age;

        if (this.age == this.maxAge) {
            this.setDead();
        }
    }

    public int getFXLayer() {
        return 3;
    }
}
