package net.minecraft.client.multiplayer;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadLanServerPing extends Thread {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    private static final Logger logger = LogManager.getLogger();
    private final String motd;
    private final DatagramSocket socket;
    private final String address;
    private boolean isStopping = true;

    public ThreadLanServerPing(String motd, String address) throws IOException {
        super("LanServerPinger #" + UNIQUE_THREAD_ID.incrementAndGet());
        this.motd = motd;
        this.address = address;
        this.setDaemon(true);
        this.socket = new DatagramSocket();
    }

    public static String getPingResponse(String motd, String address) {
        return "[MOTD]" + motd + "[/MOTD][AD]" + address + "[/AD]";
    }

    public static String getMotdFromPingResponse(String response) {
        int i = response.indexOf("[MOTD]");

        if (i < 0) {
            return "missing no";
        } else {
            int j = response.indexOf("[/MOTD]", i + "[MOTD]".length());
            return j < i ? "missing no" : response.substring(i + "[MOTD]".length(), j);
        }
    }

    public static String getAdFromPingResponse(String response) {
        int i = response.indexOf("[/MOTD]");

        if (i < 0) {
            return null;
        } else {
            int j = response.indexOf("[/MOTD]", i + "[/MOTD]".length());

            if (j >= 0) {
                return null;
            } else {
                int k = response.indexOf("[AD]", i + "[/MOTD]".length());

                if (k < 0) {
                    return null;
                } else {
                    int l = response.indexOf("[/AD]", k + "[AD]".length());
                    return l < k ? null : response.substring(k + "[AD]".length(), l);
                }
            }
        }
    }

    public void run() {
        String s = getPingResponse(this.motd, this.address);
        byte[] abyte = s.getBytes();

        while (!this.isInterrupted() && this.isStopping) {
            try {
                InetAddress inetaddress = InetAddress.getByName("224.0.2.60");
                DatagramPacket datagrampacket = new DatagramPacket(abyte, abyte.length, inetaddress, 4445);
                this.socket.send(datagrampacket);
            } catch (IOException ioexception) {
                logger.warn("LanServerPinger: {}", ioexception.getMessage());
                break;
            }

            try {
                sleep(1500L);
            } catch (InterruptedException ignored) {
            }
        }
    }

    public void interrupt() {
        super.interrupt();
        this.isStopping = false;
    }
}
