package net.minecraft.client.model;

import net.minecraft.util.Vec3;

public class PositionTextureVertex {
    public final Vec3 vector3D;
    public final float texturePositionX;
    public final float texturePositionY;

    public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
        this(new Vec3(x, y, z), texU, texV);
    }

    public PositionTextureVertex(PositionTextureVertex textureVertex, float texturePositionXIn, float texturePositionYIn) {
        this.vector3D = textureVertex.vector3D;
        this.texturePositionX = texturePositionXIn;
        this.texturePositionY = texturePositionYIn;
    }

    public PositionTextureVertex(Vec3 vector3DIn, float texturePositionXIn, float texturePositionYIn) {
        this.vector3D = vector3DIn;
        this.texturePositionX = texturePositionXIn;
        this.texturePositionY = texturePositionYIn;
    }

    public PositionTextureVertex setTexturePosition(float texturePosX, float texturePosY) {
        return new PositionTextureVertex(this, texturePosX, texturePosY);
    }
}
