package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.network.LanServerDetector;
import net.minecraft.client.resources.LanguageManager;

public class ServerListEntryLanDetected implements GuiListExtended.IGuiListEntry {
    protected final Minecraft mc;
    protected final LanServerDetector.LanServer serverData;
    private final GuiMultiplayer screen;
    private long lastClickTime = 0L;

    protected ServerListEntryLanDetected(GuiMultiplayer screenIn, LanServerDetector.LanServer serverDataIn) {
        this.screen = screenIn;
        this.serverData = serverDataIn;
        this.mc = Minecraft.getMinecraft();
    }

    public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
        this.mc.minecraftFontRendererObj.drawString(LanguageManager.format("lanServer.title"), x + 32 + 3, y + 1, 16777215);
        this.mc.minecraftFontRendererObj.drawString(this.serverData.getServerMotd(), x + 32 + 3, y + 12, 8421504);
        this.mc.minecraftFontRendererObj.drawString(this.serverData.getServerIpPort(), x + 32 + 3, y + 12 + 11, 3158064);
    }

    public boolean mousePressed(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        this.screen.selectServer(slotIndex);

        if (Minecraft.getSystemTime() - this.lastClickTime < 250L) {
            this.screen.connectToSelected();
        }

        this.lastClickTime = Minecraft.getSystemTime();
        return false;
    }

    public void setSelected(int entryID, int insideLeft, int yPos) {
    }

    public void mouseReleased(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    public LanServerDetector.LanServer getLanServer() {
        return this.serverData;
    }
}
