package net.minecraft.client.gui;

import net.minecraft.client.resources.LanguageManager;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import org.lwjgl.input.Keyboard;

import java.io.IOException;

public class GuiRenameWorld extends GuiScreen {
    private final GuiScreen parentScreen;
    private final String saveName;
    private GuiTextField textField;

    public GuiRenameWorld(GuiScreen parentScreenIn, String saveNameIn) {
        this.parentScreen = parentScreenIn;
        this.saveName = saveNameIn;
    }

    public void updateScreen() {
        this.textField.updateCursorCounter();
    }

    public void initGui() {
        Keyboard.enableRepeatEvents(true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, LanguageManager.format("selectWorld.renameButton")));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, LanguageManager.format("gui.cancel")));
        ISaveFormat isaveformat = this.mc.getSaveLoader();
        WorldInfo worldinfo = isaveformat.getWorldInfo(this.saveName);
        String s = worldinfo.getWorldName();
        this.textField = new GuiTextField(2, this.minecraftFontRendererObj, this.width / 2 - 100, 60, 200, 20);
        this.textField.setFocused(true);
        this.textField.setText(s);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == 1) {
                this.mc.displayGuiScreen(this.parentScreen);
            } else if (button.id == 0) {
                ISaveFormat isaveformat = this.mc.getSaveLoader();
                isaveformat.renameWorld(this.saveName, this.textField.getText().trim());
                this.mc.displayGuiScreen(this.parentScreen);
            }
        }
    }

    protected void keyTyped(char typedChar, int keyCode) {
        this.textField.textboxKeyTyped(typedChar, keyCode);
        this.buttonList.get(0).enabled = !this.textField.getText().trim().isEmpty();

        if (keyCode == 28 || keyCode == 156) {
            this.actionPerformed(this.buttonList.get(0));
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.textField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.minecraftFontRendererObj, LanguageManager.format("selectWorld.renameTitle"), this.width / 2, 20, 16777215);
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("selectWorld.enterName"), this.width / 2 - 100, 47, 10526880);
        this.textField.drawTextBox();
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}
