package net.minecraft.client.gui;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;

import java.io.IOException;

public class GuiCreateFlatWorld extends GuiScreen {
    private final GuiCreateWorld createWorldGui;
    private FlatGeneratorInfo theFlatGeneratorInfo = FlatGeneratorInfo.getDefaultFlatGenerator();
    private String flatWorldTitle;
    private String materialText;
    private String heightText;
    private GuiCreateFlatWorld.Details createFlatWorldListSlotGui;
    private GuiButton addLayerButton;
    private GuiButton editLayerButton;
    private GuiButton removeLayerButton;

    public GuiCreateFlatWorld(GuiCreateWorld createWorldGuiIn, String preset) {
        this.createWorldGui = createWorldGuiIn;
        this.setPreset(preset);
    }

    public String getPreset() {
        return this.theFlatGeneratorInfo.toString();
    }

    public void setPreset(String preset) {
        this.theFlatGeneratorInfo = FlatGeneratorInfo.createFlatGeneratorFromString(preset);
    }

    public void initGui() {
        this.buttonList.clear();
        this.flatWorldTitle = LanguageManager.format("createWorld.customize.flat.title");
        this.materialText = LanguageManager.format("createWorld.customize.flat.tile");
        this.heightText = LanguageManager.format("createWorld.customize.flat.height");
        this.createFlatWorldListSlotGui = new GuiCreateFlatWorld.Details();
        this.buttonList.add(this.addLayerButton = new GuiButton(2, this.width / 2 - 154, this.height - 52, 100, 20, LanguageManager.format("createWorld.customize.flat.addLayer") + " (NYI)"));
        this.buttonList.add(this.editLayerButton = new GuiButton(3, this.width / 2 - 50, this.height - 52, 100, 20, LanguageManager.format("createWorld.customize.flat.editLayer") + " (NYI)"));
        this.buttonList.add(this.removeLayerButton = new GuiButton(4, this.width / 2 - 155, this.height - 52, 150, 20, LanguageManager.format("createWorld.customize.flat.removeLayer")));
        this.buttonList.add(new GuiButton(0, this.width / 2 - 155, this.height - 28, 150, 20, LanguageManager.format("gui.done")));
        this.buttonList.add(new GuiButton(5, this.width / 2 + 5, this.height - 52, 150, 20, LanguageManager.format("createWorld.customize.presets")));
        this.buttonList.add(new GuiButton(1, this.width / 2 + 5, this.height - 28, 150, 20, LanguageManager.format("gui.cancel")));
        this.addLayerButton.visible = this.editLayerButton.visible = false;
        this.theFlatGeneratorInfo.updateLayers();
        this.onLayersChanged();
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.createFlatWorldListSlotGui.handleMouseInput();
    }

    protected void actionPerformed(GuiButton button) {
        int i = this.theFlatGeneratorInfo.getFlatLayers().size() - this.createFlatWorldListSlotGui.selectedLayer - 1;

        if (button.id == 1) {
            this.mc.displayGuiScreen(this.createWorldGui);
        } else if (button.id == 0) {
            this.createWorldGui.chunkProviderSettingsJson = this.getPreset();
            this.mc.displayGuiScreen(this.createWorldGui);
        } else if (button.id == 5) {
            this.mc.displayGuiScreen(new GuiFlatPresets(this));
        } else if (button.id == 4 && this.hasSelectedLayer()) {
            this.theFlatGeneratorInfo.getFlatLayers().remove(i);
            this.createFlatWorldListSlotGui.selectedLayer = Math.min(this.createFlatWorldListSlotGui.selectedLayer, this.theFlatGeneratorInfo.getFlatLayers().size() - 1);
        }

        this.theFlatGeneratorInfo.updateLayers();
        this.onLayersChanged();
    }

    public void onLayersChanged() {
        this.removeLayerButton.enabled = this.hasSelectedLayer();
        this.editLayerButton.enabled = false;
        this.addLayerButton.enabled = false;
    }

    private boolean hasSelectedLayer() {
        return this.createFlatWorldListSlotGui.selectedLayer > -1 && this.createFlatWorldListSlotGui.selectedLayer < this.theFlatGeneratorInfo.getFlatLayers().size();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.createFlatWorldListSlotGui.drawScreen(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.minecraftFontRendererObj, this.flatWorldTitle, this.width / 2, 8, 16777215);
        int i = this.width / 2 - 92 - 16;
        this.drawString(this.minecraftFontRendererObj, this.materialText, i, 32, 16777215);
        this.drawString(this.minecraftFontRendererObj, this.heightText, i + 2 + 213 - this.minecraftFontRendererObj.getStringWidth(this.heightText), 32, 16777215);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    class Details extends GuiSlot {
        public int selectedLayer = -1;

        public Details() {
            super(GuiCreateFlatWorld.this.mc, GuiCreateFlatWorld.this.width, GuiCreateFlatWorld.this.height, 43, GuiCreateFlatWorld.this.height - 60, 24);
        }

        private void drawItem(int x, int z, ItemStack itemToDraw) {
            this.drawItemBackground(x + 1, z + 1);
            GlStateManager.enableRescaleNormal();

            if (itemToDraw != null && itemToDraw.getItem() != null) {
                RenderHelper.enableGUIStandardItemLighting();
                GuiCreateFlatWorld.this.itemRender.renderItemIntoGUI(itemToDraw, x + 2, z + 2);
                RenderHelper.disableStandardItemLighting();
            }

            GlStateManager.disableRescaleNormal();
        }

        private void drawItemBackground(int x, int y) {
            this.drawItemBackground(x, y, 0, 0);
        }

        private void drawItemBackground(int x, int z, int textureX, int textureY) {
            GlStateManager.color(1.0F, 1.0F, 1.0F, 1.0F);
            this.mc.getTextureManager().bindTexture(Gui.statIcons);
            Tessellator tessellator = Tessellator.getInstance();
            WorldRenderer worldrenderer = tessellator.getWorldRenderer();
            worldrenderer.begin(7, DefaultVertexFormats.POSITION_TEX);
            worldrenderer.pos(x, z + 18, GuiCreateFlatWorld.this.zLevel).tex((float) (textureX) * 0.0078125F, (float) (textureY + 18) * 0.0078125F).endVertex();
            worldrenderer.pos(x + 18, z + 18, GuiCreateFlatWorld.this.zLevel).tex((float) (textureX + 18) * 0.0078125F, (float) (textureY + 18) * 0.0078125F).endVertex();
            worldrenderer.pos(x + 18, z, GuiCreateFlatWorld.this.zLevel).tex((float) (textureX + 18) * 0.0078125F, (float) (textureY) * 0.0078125F).endVertex();
            worldrenderer.pos(x, z, GuiCreateFlatWorld.this.zLevel).tex((float) (textureX) * 0.0078125F, (float) (textureY) * 0.0078125F).endVertex();
            tessellator.draw();
        }

        protected int getSize() {
            return GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size();
        }

        protected void elementClicked(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.selectedLayer = slotIndex;
            GuiCreateFlatWorld.this.onLayersChanged();
        }

        protected boolean isSelected(int slotIndex) {
            return slotIndex == this.selectedLayer;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int entryID, int insideLeft, int yPos, int insideSlotHeight, int mouseXIn, int mouseYIn) {
            FlatLayerInfo flatlayerinfo = GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().get(GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size() - entryID - 1);
            IBlockState iblockstate = flatlayerinfo.getLayerMaterial();
            Block block = iblockstate.getBlock();
            Item item = Item.getItemFromBlock(block);
            ItemStack itemstack = block != Blocks.air && item != null ? new ItemStack(item, 1, block.getMetaFromState(iblockstate)) : null;
            String s = itemstack == null ? "Air" : item.getItemStackDisplayName(itemstack);

            if (item == null) {
                if (block != Blocks.water && block != Blocks.flowing_water) {
                    if (block == Blocks.lava || block == Blocks.flowing_lava) {
                        item = Items.lava_bucket;
                    }
                } else {
                    item = Items.water_bucket;
                }

                if (item != null) {
                    itemstack = new ItemStack(item, 1, block.getMetaFromState(iblockstate));
                    s = block.getLocalizedName();
                }
            }

            this.drawItem(insideLeft, yPos, itemstack);
            GuiCreateFlatWorld.this.minecraftFontRendererObj.drawString(s, insideLeft + 18 + 5, yPos + 3, 16777215);
            String s1;

            if (entryID == 0) {
                s1 = LanguageManager.format("createWorld.customize.flat.layer.top", flatlayerinfo.getLayerCount());
            } else if (entryID == GuiCreateFlatWorld.this.theFlatGeneratorInfo.getFlatLayers().size() - 1) {
                s1 = LanguageManager.format("createWorld.customize.flat.layer.bottom", flatlayerinfo.getLayerCount());
            } else {
                s1 = LanguageManager.format("createWorld.customize.flat.layer", flatlayerinfo.getLayerCount());
            }

            GuiCreateFlatWorld.this.minecraftFontRendererObj.drawString(s1, insideLeft + 2 + 213 - GuiCreateFlatWorld.this.minecraftFontRendererObj.getStringWidth(s1), yPos + 3, 16777215);
        }

        protected int getScrollBarX() {
            return this.width - 70;
        }
    }
}
