package net.minecraft.client.gui;

import io.netty.buffer.Unpooled;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import org.lwjgl.input.Keyboard;

import java.io.IOException;

public class GuiCommandBlock extends GuiScreen {
    private final CommandBlockLogic localCommandBlock;
    private GuiTextField commandTextField;
    private GuiTextField previousOutputTextField;
    private GuiButton doneBtn;
    private GuiButton cancelBtn;
    private GuiButton outputBtn;
    private boolean trackOutput;

    public GuiCommandBlock(CommandBlockLogic commandBlock) {
        this.localCommandBlock = commandBlock;
    }

    public void updateScreen() {
        this.commandTextField.updateCursorCounter();
    }

    public void initGui() {
        Keyboard.enableRepeatEvents(true);
        this.buttonList.clear();
        this.buttonList.add(this.doneBtn = new GuiButton(0, this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, LanguageManager.format("gui.done")));
        this.buttonList.add(this.cancelBtn = new GuiButton(1, this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, LanguageManager.format("gui.cancel")));
        this.buttonList.add(this.outputBtn = new GuiButton(4, this.width / 2 + 150 - 20, 150, 20, 20, "O"));
        this.commandTextField = new GuiTextField(2, this.minecraftFontRendererObj, this.width / 2 - 150, 50, 300, 20);
        this.commandTextField.setMaxStringLength(32767);
        this.commandTextField.setFocused(true);
        this.commandTextField.setText(this.localCommandBlock.getCommand());
        this.previousOutputTextField = new GuiTextField(3, this.minecraftFontRendererObj, this.width / 2 - 150, 150, 276, 20);
        this.previousOutputTextField.setMaxStringLength(32767);
        this.previousOutputTextField.setEnabled(false);
        this.previousOutputTextField.setText("-");
        this.trackOutput = this.localCommandBlock.shouldTrackOutput();
        this.updateCmdOutput();
        this.doneBtn.enabled = !this.commandTextField.getText().trim().isEmpty();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents(false);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == 1) {
                this.localCommandBlock.setTrackOutput(this.trackOutput);
                this.mc.displayGuiScreen(null);
            } else if (button.id == 0) {
                PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
                packetbuffer.writeByte(this.localCommandBlock.getCommandBlockType());
                this.localCommandBlock.fillInInfo(packetbuffer);
                packetbuffer.writeString(this.commandTextField.getText());
                packetbuffer.writeBoolean(this.localCommandBlock.shouldTrackOutput());
                this.mc.getNetHandler().addToSendQueue(new C17PacketCustomPayload("MC|AdvCdm", packetbuffer));

                if (!this.localCommandBlock.shouldTrackOutput()) {
                    this.localCommandBlock.setLastOutput(null);
                }

                this.mc.displayGuiScreen(null);
            } else if (button.id == 4) {
                this.localCommandBlock.setTrackOutput(!this.localCommandBlock.shouldTrackOutput());
                this.updateCmdOutput();
            }
        }
    }

    protected void keyTyped(char typedChar, int keyCode) {
        this.commandTextField.textboxKeyTyped(typedChar, keyCode);
        this.previousOutputTextField.textboxKeyTyped(typedChar, keyCode);
        this.doneBtn.enabled = !this.commandTextField.getText().trim().isEmpty();

        if (keyCode != 28 && keyCode != 156) {
            if (keyCode == 1) {
                this.actionPerformed(this.cancelBtn);
            }
        } else {
            this.actionPerformed(this.doneBtn);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.commandTextField.mouseClicked(mouseX, mouseY, mouseButton);
        this.previousOutputTextField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.minecraftFontRendererObj, LanguageManager.format("advMode.setCommand"), this.width / 2, 20, 16777215);
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.command"), this.width / 2 - 150, 37, 10526880);
        this.commandTextField.drawTextBox();
        int i = 75;
        int j = 0;
        j++;
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.nearestPlayer"), this.width / 2 - 150, i, 10526880);
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.randomPlayer"), this.width / 2 - 150, i + j++ * this.minecraftFontRendererObj.FONT_HEIGHT, 10526880);
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.allPlayers"), this.width / 2 - 150, i + j++ * this.minecraftFontRendererObj.FONT_HEIGHT, 10526880);
        this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.allEntities"), this.width / 2 - 150, i + j++ * this.minecraftFontRendererObj.FONT_HEIGHT, 10526880);
        this.drawString(this.minecraftFontRendererObj, "", this.width / 2 - 150, i + j++ * this.minecraftFontRendererObj.FONT_HEIGHT, 10526880);

        if (!this.previousOutputTextField.getText().isEmpty()) {
            i = i + j * this.minecraftFontRendererObj.FONT_HEIGHT + 16;
            this.drawString(this.minecraftFontRendererObj, LanguageManager.format("advMode.previousOutput"), this.width / 2 - 150, i, 10526880);
            this.previousOutputTextField.drawTextBox();
        }

        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    private void updateCmdOutput() {
        if (this.localCommandBlock.shouldTrackOutput()) {
            this.outputBtn.displayString = "O";

            if (this.localCommandBlock.getLastOutput() != null) {
                this.previousOutputTextField.setText(this.localCommandBlock.getLastOutput().getUnformattedText());
            }
        } else {
            this.outputBtn.displayString = "X";
            this.previousOutputTextField.setText("-");
        }
    }
}
