package net.minecraft.client.gui;

import net.bloom.bloomclient.utils.render.skiko.Skiko;
import net.bloom.bloomclient.utils.render.skiko.SkikoContext;
import net.bloom.bloomclient.utils.render.skiko.font.Fonts;
import net.bloom.bloomclient.utils.render.skiko.font.SkiaFont;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

import java.awt.*;

public class GuiButton extends Gui {
    protected static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    public final int id;
    public final int height;
    public int xPosition;
    public int yPosition;
    public String displayString;
    public boolean enabled;
    public boolean visible;
    protected int width;
    protected boolean hovered;

    public GuiButton(int buttonId, int x, int y, String buttonText) {
        this(buttonId, x, y, 200, 20, buttonText);
    }

    public GuiButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText) {
        this.enabled = true;
        this.visible = true;
        this.id = buttonId;
        this.xPosition = x;
        this.yPosition = y;
        this.width = widthIn;
        this.height = heightIn;
        this.displayString = buttonText;
    }

    protected int getHoverState(boolean mouseOver) {
        int i = 1;

        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }

        return i;
    }

    private static final SkiaFont fr = Fonts.NUNITO.get(10f);

    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            mouseDragged(mc, mouseX, mouseY);

            SkikoContext.INSTANCE.preFlush();

            Skiko.INSTANCE.roundrect(xPosition, yPosition, width, height, 5f, new Color(0, 0, 0, 120));
            fr.centeredText(displayString, xPosition + width / 2, yPosition + height / 2 + 3, Color.WHITE);

            SkikoContext.INSTANCE.flush();
        }
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    public void mouseReleased(int mouseX, int mouseY) {
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && this.visible && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }

    public void drawButtonForegroundLayer(int mouseX, int mouseY) {
    }

    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.playSound(PositionedSoundRecord.create(new ResourceLocation("gui.button.press"), 1.0F));
    }

    public int getButtonWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}
