package net.lenni0451.lambdaevents.generator;

import net.lenni0451.lambdaevents.AHandler;
import net.lenni0451.lambdaevents.EventHandler;
import net.lenni0451.lambdaevents.IGenerator;
import net.lenni0451.lambdaevents.handler.reflection.ReflectionHandler;
import net.lenni0451.lambdaevents.handler.reflection.VirtualReflectionHandler;

import java.lang.reflect.Method;

/**
 * The {@link IGenerator} implementation which calls the handler method using reflection.
 */
public class ReflectionGenerator implements IGenerator {

    @Override
    public AHandler generate(Class<?> owner, Object instance, EventHandler annotation, Method method, Class<?> arg) {
        method.setAccessible(true); //Make sure the method is accessible
        return new ReflectionHandler(owner, instance, annotation, method);
    }

    @Override
    public AHandler generateVirtual(Class<?> owner, Object instance, EventHandler annotation, Method method) {
        method.setAccessible(true); //Make sure the method is accessible
        return new VirtualReflectionHandler(owner, instance, annotation, method);
    }

}
