package net.lenni0451.lambdaevents;

import java.lang.reflect.Method;

/**
 * The generator interface for the {@link AHandler} implementations.
 */
public interface IGenerator {

    /**
     * Generate an {@link AHandler} for the given method with an event parameter.
     *
     * @param owner      The owner of the handler method
     * @param instance   The instance of the handler owner
     * @param annotation The {@link EventHandler} annotation of the handler method
     * @param method     The handler method
     * @param arg        The event class
     * @return The generated handler
     */
    AHandler generate(final Class<?> owner, final Object instance, final EventHandler annotation, final Method method, final Class<?> arg) throws Throwable;

    /**
     * Generate an {@link AHandler} for the given method without an event parameter.
     *
     * @param owner      The owner of the handler method
     * @param instance   The instance of the handler owner
     * @param annotation The {@link EventHandler} annotation of the handler method
     * @param method     The handler method
     * @return The generated handler
     */
    AHandler generateVirtual(final Class<?> owner, final Object instance, final EventHandler annotation, final Method method) throws Throwable;

}
