package net.lenni0451.lambdaevents;

/**
 * The abstract handler class generated by an {@link IGenerator} implementation.
 */
public abstract class AHandler {

    protected final Class<?> owner;
    protected final Object instance;
    protected final EventHandler annotation;
    private final boolean handleCancelled;

    /**
     * @param owner      The owner of the handler method
     * @param instance   The instance of the handler owner
     * @param annotation The {@link EventHandler} annotation of the handler method
     */
    public AHandler(final Class<?> owner, final Object instance, final EventHandler annotation) {
        this.owner = owner;
        this.instance = instance;
        this.annotation = annotation;
        this.handleCancelled = annotation.handleCancelled();
    }

    /**
     * @return The owner of the handler method
     */
    public Class<?> getOwner() {
        return this.owner;
    }

    /**
     * @return The instance of the handler owner
     */
    public Object getInstance() {
        return this.instance;
    }

    /**
     * @return The {@link EventHandler} annotation of the handler method
     */
    public EventHandler getAnnotation() {
        return this.annotation;
    }

    /**
     * @return If the handler is static
     */
    public boolean isStatic() {
        return this.instance == null;
    }

    /**
     * @return If the handler should handle cancelled events
     */
    public boolean shouldHandleCancelled() {
        return this.handleCancelled;
    }

    /**
     * Call the event handler with the given event instance.
     *
     * @param event The event instance
     */
    public abstract void call(final Object event) throws Throwable;

    @Override
    public abstract String toString();

}
