package de.florianmichael.viamcp.gui;

import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.vialoadingbase.ViaLoadingBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTableSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;

public class GuiVersionListSlot extends GuiTableSlot {

    public GuiVersionListSlot(Minecraft mc, GuiScreen parent, int elementsPerRow, int width, int height, int top, int bottom) {
        super(mc, parent, elementsPerRow, width, height, top + 30, bottom);
    }

    @Override
    protected void elementClicked(int i, boolean b, int i1, int i2) {
        final ProtocolVersion protocolVersion = ViaLoadingBase.PROTOCOLS.get(i);
        ViaLoadingBase.getInstance().reload(protocolVersion);
    }

    @Override
    public int getListWidth() {
        return width - 20;
    }

    @Override
    protected int getElementsSize() {
        return ViaLoadingBase.PROTOCOLS.size();
    }

    @Override
    protected void drawSlot(int protocolIndex, int insideLeft, int yPos, int i3, int i4, int i5) {
        final ProtocolVersion protocolVersion = ViaLoadingBase.PROTOCOLS.get(protocolIndex);
        final float elementWidth = (float) this.getListWidth() / this.elementsPerRow;
        final int col = protocolIndex % this.elementsPerRow;

        final String color = ViaLoadingBase.PROTOCOLS.indexOf(ViaLoadingBase.getInstance().getTargetVersion()) == protocolIndex ? EnumChatFormatting.GREEN.toString() + EnumChatFormatting.BOLD : EnumChatFormatting.GRAY.toString();

        final double scale = 1.3D;

        GlStateManager.pushMatrix();
        GlStateManager.scale(scale, scale, scale);
        this.parent.drawString(mc.minecraftFontRendererObj, color + protocolVersion.getName(), (int) ((insideLeft + elementWidth * col) / scale), (int) ((yPos + 2) / scale), -1);
        GlStateManager.popMatrix();
    }
}