/*
 * This file is part of ViaMCP - https://github.com/FlorianMichael/ViaMCP
 * Copyright (C) 2020-2024 FlorianMichael/EnZaXD <florian.michael07@gmail.com> and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package de.florianmichael.viamcp.gui;

import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import de.florianmichael.vialoadingbase.ViaLoadingBase;
import de.florianmichael.viamcp.protocolinfo.ProtocolInfo;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;

import java.io.IOException;
import java.util.Objects;

public class GuiProtocolSelector extends GuiScreen {
    private final GuiScreen parent;
    public GuiVersionListSlot list;

    public GuiProtocolSelector(GuiScreen parent) {
        this.parent = parent;
    }

    @Override
    public void initGui() {
        super.initGui();
        buttonList.add(new GuiButton(1, width - 92, height - 36, 80, 20, "Back"));
        list = new GuiVersionListSlot(mc, this, 4, width, height, 12, height - 48);
    }

    @Override
    protected void actionPerformed(GuiButton guiButton) {
        list.actionPerformed(guiButton);

        if (guiButton.id == 1) {
            mc.displayGuiScreen(parent);
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        list.handleMouseInput();
        super.handleMouseInput();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        list.drawScreen(mouseX, mouseY, partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.scale(2.0, 2.0, 2.0);
        String title = EnumChatFormatting.BOLD + "ViaMCP";
        drawString(this.minecraftFontRendererObj, title, (this.width - (this.minecraftFontRendererObj.getStringWidth(title) * 2)) / 4, 5, -1);
        GlStateManager.popMatrix();

        drawString(this.minecraftFontRendererObj, "by EnZaXD/Flori2007", 1, 1, -1);
        drawString(this.minecraftFontRendererObj, "Discord: EnZaXD#6257", 1, 11, -1);

        final ProtocolVersion targetVersion = ViaLoadingBase.getInstance().getTargetVersion();
        final ProtocolInfo targetInfo = ProtocolInfo.fromProtocolVersion(targetVersion);

        drawString(this.minecraftFontRendererObj, "Version number: " + targetVersion.getVersion(), 8, height - this.minecraftFontRendererObj.FONT_HEIGHT * 3 - 12, -1);
        drawString(this.minecraftFontRendererObj, "Version name: " + Objects.requireNonNull(targetInfo).getName(), 8, height - this.minecraftFontRendererObj.FONT_HEIGHT * 2 - 10, -1);
        drawString(this.minecraftFontRendererObj, "Released: " + targetInfo.getReleaseDate(), 8, height - this.minecraftFontRendererObj.FONT_HEIGHT - 8, -1);

        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}
