package rip.marie.logger;

/**
 * Logs stuff to the console, acts as a replacement to println
 * @author marie
 */
public class Logger {
    /**
     * Logs a message to console
     */
    public void log(Level level, String str) {
        System.out.println(level.prefix + str);
    }

    public void info(String str) {
        log(Level.INFO, str);
    }

    public void error(String str) {
        log(Level.ERROR, str);
    }

    public void warn(String str) {
        log(Level.WARN, str);
    }
}