package fag.ml.util;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

import java.io.IOException;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

/**
 * @author markuss
 */
public class JarUtil implements Constants {
    public static HashMap<String, ClassNode> populateNodes(JarInputStream jizz, JarOutputStream jazz) throws IOException {
        HashMap<String, ClassNode> nodes = new HashMap<>();

        JarEntry entry;
        byte[] buffer = new byte[4096];

        while ((entry = jizz.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (name.endsWith(".class")) {
                ClassReader reader = new ClassReader(jizz);
                ClassNode node = new ClassNode();
                reader.accept(node, 0);
                nodes.put(node.name, node);
            } else {
                // Copy non-class entry
                if (entry.isDirectory()) continue;
                jazz.putNextEntry(new JarEntry(name));
                int len;
                while ((len = jizz.read(buffer)) != -1) {
                    jazz.write(buffer, 0, len);
                }
                jazz.closeEntry();
            }
        }

        LOGGER.warn("found " + nodes.size() + " class(es)");

        return nodes;
    }

    public static void addInAssets(HashMap<String, ClassNode> nodes, JarOutputStream jazz) throws IOException {
        for (var entrySet : nodes.entrySet()) {
            String name = entrySet.getKey();
            ClassNode node = entrySet.getValue();

            JarEntry classEntry = new JarEntry(name + ".class");
            jazz.putNextEntry(classEntry);

            ClassWriter writer = new ClassWriter(0);
            node.accept(writer);

            jazz.write(writer.toByteArray());
            jazz.closeEntry();
        }
    }
}