package fag.ml.test;

import fag.ml.test.util.SSVMUtil;
import fag.ml.util.Constants;
import fag.ml.util.JarUtil;
import org.objectweb.asm.tree.ClassNode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class Main implements Constants {
    public static HashMap<String, ClassNode> NODES;
    public static File input, output;

    public static void main(String[] args) throws Exception {
        input = new File(args[1]);
        output = new File(args[2]);

        if (input.exists()) {
            try (
                    JarInputStream jizz = new JarInputStream(new FileInputStream(input));
                    JarOutputStream jazz = new JarOutputStream(new FileOutputStream(output))
            ) {
                NODES = JarUtil.populateNodes(jizz, jazz);

                LOGGER.warn("Starting test #1 (SSVM deobfuscation)");
                SSVMUtil.deobfBase64StringArrays(NODES);

                JarUtil.addInAssets(NODES, jazz);
            }
        }
    }
}
