package fag.ml.sigma4.util;

import fag.ml.util.Constants;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.*;

import static fag.ml.sigma4.Main.NODES;

public class Sigma4PatchUtil implements Constants {
    public static void findPremiumLoader() {
        for (ClassNode cn : NODES.values()) {
            if (!"java/lang/Object".equals(cn.superName)) continue;

            int methodCount = cn.methods.size();
            if (methodCount != 2) continue;

            MethodNode constructor = null;
            MethodNode targetMethod = null;

            for (MethodNode m : cn.methods) {
                if ("<init>".equals(m.name)) constructor = m;
                else targetMethod = m;
            }

            if (constructor == null || targetMethod == null) continue;

            if (!targetMethod.desc.equals("()Z")) continue;

            int invokevirtualCount = 0;
            for (AbstractInsnNode insn : targetMethod.instructions) {
                if (insn.getOpcode() == Opcodes.INVOKEVIRTUAL) {
                    invokevirtualCount++;
                }
            }

            if (invokevirtualCount >= 30) {
                LOGGER.info("found PremiumLoader class");
                LOGGER.info("found load()Z method");
            }
        }
    }
}
