package fag.ml.sigma4;

import fag.ml.sigma4.util.Sigma4PatchUtil;
import fag.ml.util.Constants;
import fag.ml.util.JarUtil;
import org.objectweb.asm.tree.ClassNode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class Main implements Constants {
    public static HashMap<String, ClassNode> NODES;
    public static File input, output;

    public static void main(String[] args) throws Exception {
        input = new File(args[1]);
        output = new File(args[2]);

        if (input.exists()) {
            try (
                    JarInputStream jizz = new JarInputStream(new FileInputStream(input));
                    JarOutputStream jazz = new JarOutputStream(new FileOutputStream(output))
            ) {
                NODES = JarUtil.populateNodes(jizz, jazz);

                LOGGER.warn("Starting to look for PremiumLoader");
                Sigma4PatchUtil.findPremiumLoader();

                JarUtil.addInAssets(NODES, jazz);
            }
        }
    }
}