package fag.ml.sigma;

import fag.ml.sigma.util.SigmaPatchUtil;
import fag.ml.util.Constants;
import fag.ml.util.JarUtil;
import org.objectweb.asm.tree.ClassNode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

public class Main implements Constants {
    public static HashMap<String, ClassNode> NODES;
    public static File input, output;

    private static ClassNode mainClass;

    public static void main(String[] args) throws Exception {
        input = new File(args[1]);
        output = new File(args[2]);

        if (input.exists()) {
            try (
                    JarInputStream jizz = new JarInputStream(new FileInputStream(input));
                    JarOutputStream jazz = new JarOutputStream(new FileOutputStream(output))
            ) {
                NODES = JarUtil.populateNodes(jizz, jazz);

                mainClass = SigmaPatchUtil.findClassWithDiscordRpcConstructor();
                if (mainClass != null) {
                    LOGGER.info("found main class: " + mainClass.name);
                }

                LOGGER.warn("Starting to patch NCP Phase check");
                SigmaPatchUtil.patchNCPPhaseCheck();

                LOGGER.warn("Starting to look for NCP Phase class");
                SigmaPatchUtil.findNCPPhase();

                LOGGER.warn("Starting to look for & patch setting checks");
                SigmaPatchUtil.findStringSetting();
                SigmaPatchUtil.patchBooleanSetting();
                SigmaPatchUtil.patchStringSetting();

                LOGGER.warn("Starting to look for & patch premium modules");
                SigmaPatchUtil.findPremiumModules();
                SigmaPatchUtil.patchPremiumModules();

                JarUtil.addInAssets(NODES, jazz);
            }
        }
    }
}