package fag.ml.rise;

import fag.ml.rise.util.RisePatchUtil;
import fag.ml.util.Constants;
import fag.ml.util.JarUtil;
import org.objectweb.asm.tree.*;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.*;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;

/**
 * @author markuss
 */
public class Main implements Constants {
    public static HashMap<String, ClassNode> NODES;

    public static File input, output;

    public static void main(String[] args) throws Exception {
        input = new File(args[1]);
        output = new File(args[2]);

        if (input.exists()) {
            try (
                    JarInputStream jizz = new JarInputStream(new FileInputStream(input));
                    JarOutputStream jazz = new JarOutputStream(new FileOutputStream(output))
            ) {
                NODES = JarUtil.populateNodes(jizz, jazz);

                LOGGER.warn("Starting to patch security checks");
                RisePatchUtil.patchBooleanMethodAndSubclasses("hackclient/rise", "-XX:+DisableAttachMechanism");

                LOGGER.warn("Starting to patch packet log checks");
                RisePatchUtil.patchBooleanMethodAndSubclasses("hackclient/rise", "proxycap");

                LOGGER.warn("Starting to patch crashers");
                RisePatchUtil.patchUnsafeMemoryWipe();

                LOGGER.warn("Starting to patch S2C");
                RisePatchUtil.patchS2C();

                LOGGER.warn("Starting to patch websocket connection");
                RisePatchUtil.patchWebsocketConnections();

                LOGGER.warn("Starting to patch new anti debugging checks");
                RisePatchUtil.patchAntiDebuggingNew();

                JarUtil.addInAssets(NODES, jazz);
            }
        }
    }
}