import fag.ml.util.Constants;

import java.util.Set;

public class Start implements Constants {
    private static final Set<String> set = Set.of("rise", "sigma5", "sigma4");

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            LOGGER.error("Wrong number of arguments!");
            LOGGER.error("Usage: java -jar patcher.jar <" + String.join("/", set) + "> <input> <output>");
            return;
        }

        String type = args[0].toLowerCase();

        if (!set.contains(type)) {
            LOGGER.error("Invalid type argument: " + type);
            LOGGER.error("Valid options are: rise, sigma");
            return;
        }

        LOGGER.info("Starting to patch " + type + " client!");

        switch (type) {
            case "rise" -> fag.ml.rise.Main.main(args);
            case "sigma5" -> fag.ml.sigma5.Main.main(args);
            case "sigma4" -> fag.ml.sigma4.Main.main(args);
        }

        LOGGER.info("Successfully patched " + type + " client!");
        LOGGER.info("Patcher made by mark with help from mainline");
    }
}