package fag.ml.util;

import fag.ml.Main;
import rip.marie.logger.Level;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class NetworkUtil {
    public static void download(String urlStr, String path) throws IOException {
        URL url = new URL(urlStr);
        Main.LOGGER.log(Level.INFO, "downloading " + urlStr);
        try (InputStream in = url.openStream();
             FileOutputStream out = new FileOutputStream(path)) {
            byte[] buffer = new byte[4096];
            int len;
            while ((len = in.read(buffer)) != -1)
                out.write(buffer, 0, len);
        }
        Main.LOGGER.log(Level.INFO, "downloaded " + path);
    }

    public static void downloadIfNotExists(String url, String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            System.out.println("info > skipped " + path + " already exists");
            return;
        }
        download(url, path);
    }
}
