package fag.ml;

import fag.ml.util.FileUtil;
import fag.ml.util.JVMUtil;
import fag.ml.util.NetworkUtil;
import rip.marie.logger.Level;
import rip.marie.logger.Logger;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class Main {
    public static final Logger LOGGER = new Logger();

    public static void main(String[] args) throws Exception {
        var bruh = Boolean.getBoolean("devMode");

        var version = Runtime.version();
        if (version.version().getFirst() != 21) {
            LOGGER.log(Level.WARN, "Launcher may have issues on your version of Java. Recommended is 21.0.x!");
        }

        File filesDir = new File("files");
        filesDir.mkdirs();

        if (!bruh) {
            NetworkUtil.download("https://wonderland.sigmaclient.cloud/data/rise/rizzgod-machine-1.8.jar", "files/patcher.jar");
            NetworkUtil.download("https://gitlab.com/rise_update/rise-update/-/raw/main/Libraries.jar?ref_type=heads&inline=false", "files/libs.jar");
            NetworkUtil.download("https://gitlab.com/rise_update/rise-update/-/raw/main/Standalone.jar?ref_type=heads&inline=false", "files/rise.jar");

            JVMUtil.runJarMain("files/patcher.jar", new String[]{"rise", "files/rise.jar", "files/crackedrise.jar"});
        }

        List<URL> classpath = new ArrayList<>();
        classpath.add(new File("files/crackedrise.jar").toURI().toURL());
        classpath.add(new File("files/libs.jar").toURI().toURL());

        String nativeLibPath = getNatives(classpath);
        if (nativeLibPath == null) {
            throw new UnsupportedOperationException("Rise does not support your OS!");
        }

        emulator.Main.startAsync();
        if (bruh) {
            for (URL url : classpath) {
                System.out.println(url.getPath());
            }
        }


        JVMUtil.runInNewJvm("Start", classpath, nativeLibPath);
    }

    private static String getNatives(List<URL> classpath) throws IOException {
        String os = System.getProperty("os.name").toLowerCase();

        String nativeLibPath;
        if (os.contains("linux")) {
            File nativesDir = new File("files/linux/natives");
            File zipFile = new File("files/linux-natives.zip");

            if (!nativesDir.exists()) {
                NetworkUtil.downloadIfNotExists("https://wonderland.sigmaclient.cloud/data/rise/linux-natives.zip", zipFile.getPath());
                FileUtil.unzipIfNotExists(zipFile.getPath(), nativesDir.getPath());
                zipFile.delete();
            }

            NetworkUtil.downloadIfNotExists("https://github.com/WonderlandCentral/wonderland-repository/raw/refs/heads/main/io/netty/netty-all/4.0.23.Final/netty-all-4.0.23.Final.jar", "files/linux/netty-all-4.0.23.Final.jar");
            classpath.add(new File("files/linux/netty-all-4.0.23.Final.jar").toURI().toURL());
            nativeLibPath = nativesDir.getAbsolutePath();
        } else if (os.contains("win")) {
            File nativesDir = new File("files/windows/natives");
            File zipFile = new File("files/windows-natives.zip");

            if (!nativesDir.exists()) {
                NetworkUtil.downloadIfNotExists("https://wonderland.sigmaclient.cloud/data/rise/windows-natives.zip", zipFile.getPath());
                FileUtil.unzipIfNotExists(zipFile.getPath(), nativesDir.getPath());
                zipFile.delete();
            }

            nativeLibPath = nativesDir.getAbsolutePath();
        } else if (os.contains("mac")) {
            File nativesDir = new File("files/macos/natives");
            File zipFile = new File("files/macos-natives.zip");

            if (!nativesDir.exists()) {
                NetworkUtil.downloadIfNotExists("https://wonderland.sigmaclient.cloud/data/rise/macos-natives.zip", zipFile.getPath());
                FileUtil.unzipIfNotExists(zipFile.getPath(), nativesDir.getPath());
                zipFile.delete();
            }

            nativeLibPath = nativesDir.getAbsolutePath();
        } else {
            LOGGER.log(Level.ERROR, "Launcher is not supported on your operating system!");
            return null;
        }
        return nativeLibPath;
    }
}