package emulator.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import emulator.Main;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public class DecryptUtil {
    public static String convert(String config) {
        JsonObject jsonObject = JsonParser.parseString(config).getAsJsonObject();

        String theme = jsonObject.get("theme").getAsString();
        StringBuilder stringBuilder = new StringBuilder();

        stringBuilder.append("th_").append(theme).append("\n");

        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
            String module = entry.getKey();
            if (!module.contains(".")) continue;

            JsonObject moduleObject = entry.getValue().getAsJsonObject();

            if (moduleObject.has("state")) {
                stringBuilder
                        .append(module)
                        .append("_e1_")
                        .append(moduleObject.get("state").getAsBoolean())
                        .append("\n");
            }

            if (moduleObject.has("keyCode")) {
                stringBuilder
                        .append(module)
                        .append("_kc_")
                        .append(moduleObject.get("keyCode").getAsInt())
                        .append("\n");
            }

            for (Map.Entry<String, JsonElement> settingEntry : moduleObject.entrySet()) {
                String setting = settingEntry.getKey();
                if (setting.equals("state") || setting.equals("keyCode")) continue;

                JsonElement value = settingEntry.getValue();
                if (value.isJsonObject()) {
                    JsonObject settingObj = value.getAsJsonObject();
                    for (Map.Entry<String, JsonElement> subSetting : settingObj.entrySet()) {
                        stringBuilder
                                .append(module)
                                .append("_")
                                .append(setting)
                                .append("_")
                                .append(subSetting.getKey())
                                .append("_")
                                .append(subSetting.getValue().getAsString().replace("\"", ""))
                                .append("\n");
                    }
                }
            }
        }

        return stringBuilder.toString();
    }

    public static String decrypt(String encryptedValue) {
        byte[] keyBytes = Main.encryptionKey.getBytes(StandardCharsets.UTF_8);
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedValue);
        byte[] decryptedBytes = new byte[encryptedBytes.length];
        for (int i = 0; i < encryptedBytes.length; i++) {
            decryptedBytes[i] = (byte) (encryptedBytes[i] ^ keyBytes[i % keyBytes.length]);
        }
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }
}
