package emulator;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import emulator.util.DecryptUtil;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import rip.marie.logger.Level;

@ServerEndpoint("/")
public class Endpoint {
    @OnMessage
    public void onMessage(String message, Session session) {
        String decrypted = DecryptUtil.decrypt(message);
        JsonObject jsonObject = JsonParser.parseString(decrypted).getAsJsonObject();

        if (!jsonObject.has("id")) {
            Main.LOGGER.log(Level.ERROR, "Returned because of unknown id");
            return;
        }

        int id = jsonObject.get("id").getAsInt();

        if (!jsonObject.toString().contains("creationDate"))
            Main.LOGGER.log(Level.INFO, "Received message with data: " + jsonObject);
        else
            Main.LOGGER.log(Level.INFO, "Received message with config data, not printing out");

        if (id > 2) return;

        JsonObject output = new JsonObject();
        output.addProperty("id", id);

        Main.lastKeepAlive = System.currentTimeMillis();

        if (id == 1) {
            output.addProperty("a", true);
            output.addProperty("b", Math.PI);
            output.addProperty("c", 90.0f);
            output.addProperty("d", System.currentTimeMillis());
            output.addProperty("e", "Hello, World!");
            Main.loggedIn = true;

            Main.LOGGER.log(Level.INFO, "Client logged in successfully");
        }

        if (id == 2) {
            output.addProperty("a", DecryptUtil.convert(jsonObject.get("a").getAsString()));
        }

        session.getAsyncRemote().sendText(output.toString());
    }
}