package cc.polymorphism.obfuscator.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Utility class for various I/O and File operations.
 *
 * @author itzsomebody
 */
public class IOUtils {
    /**
     * Return a given {@link InputStream} as a byte array.
     *
     * @return Byte array representation of provided {@link InputStream}.
     */
    public static byte[] toByteArray(final InputStream stream) throws IOException {
        try (stream; var out = new ByteArrayOutputStream()) {
            var buf = new byte[0x1000];
            int bytesRead;
            while ((bytesRead = stream.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, bytesRead);
            }
            out.flush();
            return out.toByteArray();
        }
    }
}
