package cc.polymorphism.obfuscator.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import lombok.experimental.UtilityClass;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

@UtilityClass
public class FileUtils {
    public JsonObject readJsonFromFile(Gson gson, File file) {
        try {
            return gson.fromJson(new FileReader(file), JsonObject.class);
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public void writeJsonToFile(Gson gson, JsonObject json, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            gson.toJson(json, writer);
            writer.close();
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}