package cc.polymorphism.obfuscator.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@SuppressWarnings("unused")
public abstract class Manager<T> extends ArrayList<T> {
    public abstract void init();

    public void register(final T object) {
        this.add(object);
    }

    @SafeVarargs
    public final void register(final T... objects) {
        this.addAll(Arrays.asList(objects));
    }

    public void unregister(final T object) {
        this.remove(object);
    }

    @SafeVarargs
    public final void unregister(final T... objects) {
        this.removeAll(Arrays.asList(objects));
    }

    public final List<T> getMultipleBy(final Predicate<? super T> predicate) {
        return this.stream()
                .filter(predicate)
                .toList();
    }

    public final T getBy(final Predicate<? super T> predicate) {
        return this.stream()
                .filter(predicate)
                .findFirst().orElse(null);
    }

    public final List<T> getObjects() {
        return new ArrayList<>(this);
    }

}
