package cc.polymorphism.obfuscator.mutator.impl.encryption.number.common;

import cc.polymorphism.obfuscator.mutator.common.Executor;
import cc.polymorphism.obfuscator.util.RandomUtils;
import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class XorSwitchByteExecutor extends Executor<Byte, ByteData> {
    private final XorByteExecutor[] key = new XorByteExecutor[RandomUtils.randomInt(2, 7) + 1];

    public XorSwitchByteExecutor() {
        for (int i = 0; i < key.length; i++) {
            this.key[i] = new XorByteExecutor();
        }
    }

    @Override
    public String code() {
        // @formatter:off
        final var cases = new StringBuilder();
        for (var i = 0; i < this.key.length; i++) {
            cases.append("""
                            case REPLACE_VALUE:
                                REPLACE_EXECUTOR
                                break;
                         """
                    .replaceAll("REPLACE_VALUE", String.valueOf(i))
                    .replaceAll("REPLACE_EXECUTOR", key[i].code())
            );
        }

        return  """
                switch (i % REPLACE_LENGTH) {
                    REPLACE_CASES
                }
                """
                .replaceAll("REPLACE_LENGTH", String.valueOf(this.key.length))
                .replaceAll("REPLACE_CASES", cases.toString());
        // @formatter:on
    }

    @Override
    public Byte execute(Byte value, ByteData data) {
        return this.key[data.index() % this.key.length].execute(value, data);
    }
}
