package cc.polymorphism.obfuscator.mutator.impl.encryption.number.common;

import cc.polymorphism.obfuscator.mutator.common.Executor;
import cc.polymorphism.obfuscator.util.RandomUtils;

public class XorByteExecutor extends Executor<Byte, ByteData> {
    private final ByteExecutorVariant variant;
    private final int key;

    public XorByteExecutor() {
        this.variant = ByteExecutorVariant.values()[RandomUtils.randomInt(ByteExecutorVariant.values().length)];
        this.key = RandomUtils.randomInt();
    }

    @Override
    public String code() {
        final var code = switch (variant) {
            case CLASS_HASH ->
                    "REPLACE_VALUE_NAME = (byte) (REPLACE_VALUE_NAME ^ new Throwable().getStackTrace()[0].getClassName().hashCode() ^ REPLACE_KEY)";
            case METHOD_HASH ->
                    "REPLACE_VALUE_NAME = (byte) (REPLACE_VALUE_NAME ^ new Throwable().getStackTrace()[1].getMethodName().hashCode() ^ REPLACE_KEY)";
            default -> "REPLACE_VALUE_NAME = (byte) (REPLACE_VALUE_NAME ^ REPLACE_KEY)";
        };

        // @formatter:off
        return  """
                REPLACE_CODE;
                """
                .replaceAll("REPLACE_CODE", code)
                .replaceAll("REPLACE_VALUE_NAME", "b")
                .replaceAll("REPLACE_KEY", String.valueOf(key));
        // @formatter:on
    }

    @Override
    public Byte execute(Byte value, ByteData data) {
        return (byte) switch (variant) {
            case CLASS_HASH -> value ^ data.classNameHash() ^ key;
            case METHOD_HASH -> value ^ data.methodNameHash() ^ key;
            default -> value ^ key;
        };
    }

    enum ByteExecutorVariant {
        NORMAL, CLASS_HASH, METHOD_HASH
    }
}
